﻿Imports System.Xml.Serialization
Public Class AddressBook
    Inherits SerializableData

    'Składowe.
    <XmlIgnore()> Public Items As New ArrayList

    'Metoda AddAddress - dodaje nowy adres do książki adresowej.
    Public Function AddAddress() As Address
        'Tworzenie adresu.
        Dim newAddress As New Address()
        'Dodawanie go do listy.
        Items.Add(newAddress)
        'Zwracanie adresu.
        Return newAddress
    End Function

    'Właściwość Addresses - właściwość używająca elementów
    'kolekcji jak elementów tablicy.
    Public Property Addresses() As Address()
        Get
            'Tworzenie nowej tablicy.
            Dim addressArray(Items.Count - 1) As Address
            Items.CopyTo(addressArray)
            Return addressArray
        End Get
        Set(ByVal Value As Address())
            'Czyszczenie zawartości obiektu ArrayList.
            Items.Clear()
            'Czy należy dodać nowe wartości?
            If Not Value Is Nothing Then
                'Przejście po tablicy i utworzenie elementów.
                Dim address As Address
                For Each address In Value
                    Items.Add(address)
                Next
            End If
        End Set
    End Property

End Class
